<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Conversor Monedas</title>
    <style>
        .formulario{
            margin-left: auto;
            margin-right: auto;
            border: 3px solid black;
            width: 30%;
            border-radius: 20px;
            text-align: center;
        }

        button{
            margin-left: auto;
            margin-right: auto;
            text-align: center;
            display: block;
        }
    </style>
</head>
<body>
    <div class="formulario">
        <h1>Conversión Monedas</h1>
        <form action="conversorMonedas.php" method="post">
            <label for="euros"><span>Euros</span></label>
            <input type="number" name="euros" id="euros" min="1" max="10000" step="0.01" required placeholder="Euros"><br> <br>
            <label for="tipo"><span>Tipo de moneda</span></label>
            <select name="tipo" id="tipo">
                <option value="yen">Yen</option>
                <option value="yuan">Yuan</option>
                <option value="libra">Libra Esterlina</option>
                <option value="franco">Franco Suizo</option>
                <option value="dolar">Dolar Canadiense</option>
                </select>
            <br><br>
            <input type="submit" value="Convertir">
        </form>
        <br>

        <?php
            if($_POST){
                $euros = $_POST["euros"];
                $conversion = 0;
                $tipo = $_POST["tipo"];
                switch($tipo){
                    case "yen":
                        $conversion = round($euros * 163.09, 2);
                        break;
                    case "yuan":
                        $conversion = round($euros * 8.25, 2);
                        break; 
                    case "libra":
                        $conversion = round($euros * 0.85, 2);
                        break;
                    case "franco":
                        $conversion = round($euros * 0.93, 2);
                        break;
                    case "dolar":
                        $conversion = round($euros * 1.57, 2);
                        break;
                }

                echo "$euros euros equivalen a " . $conversion ." ". $tipo."s";
            }
        ?>
        <br><br>
    </div>
    <br><br>
    <button><a href="../../index.html">Volver</a></button>
</body>
</html>