let estadoAdd = 0; //0 cerrado 1 abierto

$(function () {
    cargarClientes();
});

function abriradd() {
    if (estadoAdd == 0) {
        $("#add").show();
        estadoAdd = 1;
    } else {
        $("#add").hide();
        estadoAdd = 0;
    }
}

function add() {
    $("#buscar").val("");
    let nombre = $("#nombre").val();
    let dni = $("#dni").val();
    let mail = $("#mail").val();
    let telefono = $("#telefono").val();
    let fecha_nacimiento = $("#fecha_nacimiento").val();
    let puntos = $("#puntos").val();
    if (nombre.length > 0 && dni.length > 0 && mail.length > 0 && telefono.length > 0 && fecha_nacimiento.length > 0 && puntos >= 0) {
        if (!validarEmail(mail)) {
            alert("Correo Incorrepto");
            return;
        }
        if (!validarFormatoDNI(dni)) {
            alert("Identificación Incorrepta");
            return;
        }

        $.post("includes/add.php", { nombre: nombre, dni: dni, mail: mail, telefono: telefono, fecha_nacimiento: fecha_nacimiento, puntos: puntos })
            .done(function (data) {
                if (data == "error") {
                    alert("Algo ha fallado");
                } else {
                    cargarClientes();
                    $("#add input").val("");
                    $("#puntos").val(0);
                }
            });

    } else {
        alert("Debe Introducir Datos...");
    }
}


function cargarClientes() {
    let palabra = "";
    if ($("#buscar").val().length >= 3) {
        palabra = $("#buscar").val();
    }

    $.getJSON("includes/clientes.php", {
        palabra: palabra
    })
        .done(function (data) {
            let codigohtml = "";
            if (data.length > 0) {
                $.each(data, function (i, item) {
                    codigohtml += `
                    <li id='cliente_${item.id}'>
                    <div>${item.dni}</div>
                    <div>${item.nombre}</div>
                    <div><input type="text" id="telefono_${item.id}" value="${item.telefono}"></div>
                    <div><input type="email" id="mail_${item.id}" value="${item.mail}"></div>
                    <div>${item.fecha_nacimiento}</div>
                    `;
                    if (item.activo == 0) {
                        codigohtml += `
                    <div>CLIENTE</div>
                    <div>NO</div>
                    <div>ACTIVO</div>
                </li>`;
                    } else {
                        codigohtml += `
                            <div><input type="number" id="dinero_${item.id}" placeholder="Cantidad" onkeyup="calcularPuntos(${item.id});"></div>
                            <div>
                                <input type="number" id="puntos_${item.id}" placeholder="Puntos" value="0">
                                <i onclick="puntos(${item.id});" class="fa-solid fa-money-bill-transfer"></i>
                            </div>
                            <div id="puntosactuales_${item.id}">${item.puntos}</div>
                        </li>`;
                    }
                });
                $("#clientes ul").html(codigohtml);
            } else {
                alert("No se han encontrado clientes");
            }
        });
}

function puntos(idcliente) {
    let p = $("#puntos_" + idcliente).val();
    $.post("includes/puntos.php", { puntos: p, id: idcliente })
        .done(function (data) {
            if (data == "error") {
                alert("Algo ha fallado");
            } else {
                $("#puntosactuales_"+idcliente).html(data);
            }
        });

}


function calcularPuntos(idcliente) {
    let dinero = $("#dinero_" + idcliente).val();
    console.log(dinero);
    let puntos = dinero * 2 / 100;
    $("#puntos_" + idcliente).val(puntos);
}


//Validador de correos
function validarEmail(valor) {
    if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor)) {
        return true;
    } else {
        return false;
    }
}


function validarFormatoDNI(dni) {
    //'use strict';
    var esvalido = 1;

    var DNI_REGEX = /^(\d{8})([A-Z])$/;
    var CIF_REGEX = /^([ABCDEFGHJKLMNPQRSUVW])(\d{7})([0-9A-J])$/;
    var NIE_REGEX = /^[XYZ]\d{7,8}[A-Z]$/;

    var ValidateSpanishID = function (str) {
        // Ensure upcase and remove whitespace
        str = str.toUpperCase().replace(/\s/, '');

        var valid = false;
        var type = spainIdType(str);

        switch (type) {
            case 'dni':
                valid = validDNI(str);
                break;
            case 'nie':
                valid = validNIE(str);
                break;
            case 'cif':
                valid = validCIF(str);
                break;
        }

        return valid
    };

    var spainIdType = function (str) {
        if (str.match(DNI_REGEX)) {
            return 'dni';
        }
        if (str.match(CIF_REGEX)) {
            return 'cif';
        }
        if (str.match(NIE_REGEX)) {
            return 'nie';
        }
    };

    var validDNI = function (dni) {
        var dni_letters = "TRWAGMYFPDXBNJZSQVHLCKE";
        var letter = dni_letters.charAt(parseInt(dni, 10) % 23);

        return letter == dni.charAt(8);
    };

    var validNIE = function (nie) {

        // Change the initial letter for the corresponding number and validate as DNI
        var nie_prefix = nie.charAt(0);

        switch (nie_prefix) {
            case 'X': nie_prefix = 0; break;
            case 'Y': nie_prefix = 1; break;
            case 'Z': nie_prefix = 2; break;
        }

        return validDNI(nie_prefix + nie.substr(1));

    };

    var validCIF = function (cif) {

        var match = cif.match(CIF_REGEX);
        var letter = match[1],
            number = match[2],
            control = match[3];

        var even_sum = 0;
        var odd_sum = 0;
        var n;

        for (var i = 0; i < number.length; i++) {
            n = parseInt(number[i], 10);

            // Odd positions (Even index equals to odd position. i=0 equals first position)
            if (i % 2 === 0) {
                // Odd positions are multiplied first.
                n *= 2;

                // If the multiplication is bigger than 10 we need to adjust
                odd_sum += n < 10 ? n : n - 9;

                // Even positions
                // Just sum them
            } else {
                even_sum += n;
            }

        }

        var control_digit = (10 - (even_sum + odd_sum).toString().substr(-1));
        var control_letter = 'JABCDEFGHI'.substr(control_digit, 1);

        // Control must be a digit
        if (letter.match(/[ABEH]/)) {
            return control == control_digit;

            // Control must be a letter
        } else if (letter.match(/[KPQS]/)) {
            return control == control_letter;

            // Can be either
        } else {
            return control == control_digit || control == control_letter;
        }

    };


    return ValidateSpanishID(dni);
}
